% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/rotation_tests.R
\name{plot_error_correction_panel}
\alias{plot_error_correction_panel}
\title{Plot error correction panel}
\usage{
plot_error_correction_panel(
  results_robust,
  use_contemporaneous_X = TRUE,
  main_left = expression(u[t] == Y[t] - hat(mu)[Y](X[t])),
  main_right = "Half-life de u[t]"
)
}
\arguments{
\item{results_robust}{List. Results from main analysis pipeline.}

\item{use_contemporaneous_X}{Logical. Use contemporaneous X (time t) or lagged
X (time t-1) for computing equilibrium path? Default is FALSE (lagged).}

\item{main_left}{Character string. Title for left panel. Default is
"Error Correction Terms u_t".}

\item{main_right}{Character string. Title for right panel. Default is
"Half-Lives of Error Correction".}
}
\value{
Invisibly returns a list with components:
\describe{
\item{\code{U}}{Matrix of error correction terms (T x Ky).}
\item{\code{half_lives}}{Vector of estimated half-lives for each Y factor.}
}
}
\description{
Creates a two-panel plot showing (1) error correction terms over time and
(2) their estimated half-lives, providing visual assessment of convergence speed.
}
