% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/ComputeCope.R
\name{ComputeCope}
\alias{ComputeCope}
\title{Compute CoPE sets.}
\usage{
ComputeCope(Z, level, X = NULL, w = NULL, correlation = NULL,
  corpar = NULL, groups = NULL, V = NULL, alpha = 0.1, N = 1000,
  mu = NULL, mask = NULL)
}
\arguments{
\item{Z}{A list with components "x", "y" and "z". Here, x and y are the 
coordinates of the grid on which the data is observed and z is an 
array with dimensions c(length(x),length(y),n), containing the
data. n is the number of observations.}

\item{level}{The level of interest.}

\item{X}{The design matrix of the linear model. If NULL, it is set to 
matrix(rep(1,dim(Y)[3]),ncol=1) corresponding to i.i.d. data.}

\item{w}{A vector of length nrow(X) indicating the desired linear combination
of coefficients to be used in inference, i.e., t(w) %*% coeffs.  If 
NULL, the default is c(1, rep(0, ncol(X) - 1)).}

\item{correlation}{Type of correlation assumed for the spatially indexed 
indexed linear models. This is a string that is passed to
the function gls from the nlme package. Defaults to NULL 
which corresponds to i.i.d. errors.}

\item{corpar}{A list of parameters passed to the correlation function.}

\item{groups}{A factor vector describing groups that are used in the \code{correlation} function.  Should have the same length as \code{X}.}

\item{V}{A 4-dimensional array containing the covariance matrix associated with each element of \code{Z$z}.  See Details.}

\item{alpha}{The significance level. Inclusion for CoPE sets holds with 
probability 1-alpha.}

\item{N}{The number of bootstrap realizations to generate for determining
the threshold.}

\item{mu}{The true parameter function. Use the default NULL if unknown.}

\item{mask}{Pixels outside the mask (i.e. where mask is == NA) are ignored.}
}
\value{
An object of class cope. A list containing the following
\itemize{
 \item{x, y: }{The grid coordinates from the input.}
 \item{mu, level, tau, X, N, alpha, mask: }
 {The corresponding values from the input.}
 \item{mu_hat, norm_est: }{The estimatot for mu and its normalized version.}
 \item{a_MB, a_MB_true, a_Tay, a_Tay_true: }{Thresholds for the CoPE sets 
 determined using the multiplier bootstrap or Taylor's method and the 
 estimated or the true contour, respectively.}
 \item{incl_MB, incl_MB_true, incl_Tay, incl_Tay_true: }{Booleans indicating 
 whether inclusion of the excursion set in the upper CoPE set and inclusion
 of the lower CoPE set in the excursion set holds, when CoPE sets are
 determined by a_MB, a_MB_true, a_Tay or a_Tay_true, respectively. Only 
 available if mu is given.}
}
}
\description{
Computes CoPE sets for the data Y using the algorithm from Sommerfeld, Sain
and Schwartzman (2015).
}
\details{
The \code{V} argument is a 4-dimensional array containing the covariance 
matrices associated with \code{Z$z}.  Specifically, \code{V[i,j,,]} is the 
covariance matrix of the data in \code{Z$z[i,j,]}.  If \code{V} is specified, 
then the covariance matrix in each element of the array is used to transform 
\code{X} and the appropriate element of \code{Z$z} before fitting the linear 
model.  This is used in place of estimating the covariance matrix withing the 
\code{nlme::gls} function.
}
\examples{
# An example using the ToyNoise and ToySignal of this package.
\dontrun{
n = 30
Data = ToyNoise1(n = n)
Data$z = Data$z + rep(ToySignal()$z, n)
CopeSet = ComputeCope(Data,level=4/3, mu=ToySignal()$z)
PlotCope(CopeSet)}
}
\references{
M. Sommerfeld, S. Sain and A. Schwartzman. Confidence regions for 
            excursion sets in asymptotically Gaussian
            random fields, with an application to climate. Preprint, 2015.
}

