% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/countland_subset.R
\name{SubsetCells}
\alias{SubsetCells}
\title{Subsets cells using a vector of cell indices}
\usage{
SubsetCells(C, cell_indices, remove_empty = TRUE)
}
\arguments{
\item{C}{countland object}

\item{cell_indices}{vector of cell index values}

\item{remove_empty}{filter out cells and genes with no observed counts (default=TRUE)}
}
\value{
countland object, count matrix updated
}
\description{
Subsets cells using a vector of cell indices
}
\examples{
gold_path <- system.file("testdata", package = "countland", mustWork = TRUE)
gold.data <- Seurat::Read10X(data.dir = gold_path)
C <- countland(gold.data)
C <- SubsetCells(C,cell_indices=1:50)
}
