% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/get_mutual_information.R
\name{get_mutual_information}
\alias{get_mutual_information}
\title{Calculate Mutual Information}
\usage{
get_mutual_information(table)
}
\arguments{
\item{table}{A numeric matrix or table. A contingency table or frequency table of two variables.}
}
\value{
A numeric value representing the mutual information between the two variables.
}
\description{
This function calculates the mutual information between two variables based on their joint distribution.
Mutual information measures the amount of information obtained about one variable through the other.
}
\details{
The mutual information is calculated using the formula:
[ I(X, Y) = H(X) + H(Y) - H(X, Y) ]
where:
\itemize{
\item \( H(X) \) is the entropy of variable X,
\item \( H(Y) \) is the entropy of variable Y, and
\item \( H(X, Y) \) is the joint entropy of X and Y.
}
}
\examples{
# Example usage with a simple contingency table:
pair_table <- table(c(1, 2, 2, 3), c(1, 1, 2, 2))
get_mutual_information(pair_table)

}
