% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/plot_covid.R
\name{plot_covid}
\alias{plot_covid}
\title{Grafica los casos de COVID-19}
\usage{
plot_covid(
  datos_covid,
  df_name = "casos",
  df_date_index = stringr::str_subset(colnames(datos_covid[df_name][[1]]),
    "FECHA|fecha|Fecha"),
  df_variable = NULL,
  df_covariates = c(),
  facet_scale = "free_y",
  facet_ncol = 4,
  date_break_format = "2 months",
  date_labels_format = "\%B-\%y",
  type = c("point", "line", "spline", "area"),
  plot_theme = ggplot2::theme(panel.background = ggplot2::element_rect(fill = "white"),
    plot.background = ggplot2::element_rect(fill = "white"), axis.text.x =
    ggplot2::element_text(angle = 90, hjust = 1), axis.line.x =
    ggplot2::element_line(color = "black"), legend.position = "none"),
  ...
)
}
\arguments{
\item{datos_covid}{(\strong{obligatorio}) Lista de \code{tibble}s resultante de \code{\link[=casos]{casos()}}, \code{\link[=cfr]{cfr()}},
\code{\link[=chr]{chr()}}, \code{\link[=positividad]{positividad()}} o \code{\link[=rt]{rt()}}}

\item{df_name}{(\strong{opcional}) Nombre de la base de datos dentro de la lista \code{datos_covid}}

\item{df_date_index}{(\strong{opcional}) Nombre de la variable que contiene la fecha}

\item{df_variable}{(\strong{opcional}) Nombre de la variable que se va a graficar en el eje y}

\item{df_covariates}{(\strong{opcional}) Covariables para el \code{facet_wrap} (maximo 2)}

\item{facet_scale}{(\strong{opcional}) Escala para el \code{\link[ggplot2:facet_wrap]{ggplot2::facet_wrap()}}}

\item{facet_ncol}{(\strong{opcional})  Numero de columnas para el \code{\link[ggplot2:facet_wrap]{ggplot2::facet_wrap()}}}

\item{date_break_format}{(\strong{opcional}) Breaks para el eje x \code{\link[ggplot2:scale_date]{ggplot2::scale_x_date()}}}

\item{date_labels_format}{(\strong{opcional}) Formato de fecha para el eje x \code{\link[ggplot2:scale_date]{ggplot2::scale_x_date()}}}

\item{type}{(\strong{opcional}) Tipo de grafica (\code{line}, \code{area}, \code{spline} o \code{point})}

\item{plot_theme}{(\strong{opcional}) Tema para el \code{ggplot2} (ejemplo \code{\link[ggplot2:ggtheme]{ggplot2::theme_classic()}}).}

\item{...}{(\strong{opcional}) Parametros adicionales para \code{\link[ggformula:geom_spline]{ggformula::geom_spline()}} en caso de elegir
\code{type="spline"}}
}
\value{
Un \code{ggplot2} con la imagen graficada.
}
\description{
\code{plot_covid} Intenta graficar automaticamente la base de datos de covid generados por \code{\link[=casos]{casos()}}
}
\examples{

# Para el ejemplo usaremos los datos precargados (datosabiertos) pero tu puedes
# correr el ejemplo descargando informacion mas reciente:
datos_covid <- datosabiertos

# Aqui muchos aparecen en cero si usas el default de datosabiertos
# porque la base de datosabiertos tiene muy pocos casos
datos_covid |>
  casos(list_name = "casos_for_plot", group_by_entidad = FALSE) |>
  plot_covid(df_name = "casos_for_plot")

# Grafica de casos nacional
\donttest{
datos_covid |>
  casos(group_by_entidad = FALSE, list_name = "plot_nal") |>
  plot_covid(df_name = "plot_nal")

# Ajuste mediante splines
datos_covid |>
  casos(group_by_entidad = FALSE, list_name = "spline_nacional") |>
  plot_covid(df_name = "spline_nacional", type = "spline", spar = 0.5)

# Graficacion por covariables
# el objeto devuelto es un objeto de ggplot2 al que se le puede dar formato
if (!requireNamespace("ggplot2", quietly = TRUE)) {
  datos_covid |>
    chr(
      group_by_entidad = TRUE, list_name = "plot_nal", .grouping_vars = c("SEXO"),
      entidades = c("BAJA CALIFORNIA", "BAJA CALIFORNIA SUR")
    ) |>
    plot_covid(
      df_name = "plot_nal",
      date_break_format = "1 week",
      date_labels_format = "\%d/\%B/\%Y",
      df_covariates = c("SEXO", "ENTIDAD_FEDERATIVA"),
      type = "area"
    ) +
    ggplot2::ggtitle("Plot nacional")
}

# Puedes tambien primero editar el tibble que usaras por ejemplo poniendo
# los nombres de los sexos
datos_covid <- datos_covid |>
  chr(
    group_by_entidad = TRUE, list_name = "plot_nal", .grouping_vars = c("SEXO"),
    entidades = c("BAJA CALIFORNIA", "BAJA CALIFORNIA SUR")
  )
}

# Finalmente desconectamos
datos_covid$disconnect()

}
\seealso{
\code{\link[=casos]{casos()}}
}
