% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/CowbellAnalyzer.R
\name{plot.cowbell}
\alias{plot.cowbell}
\title{Plots the obtained cowbell function.}
\usage{
\method{plot}{cowbell}(x, breakPointUsed = TRUE, ...)
}
\arguments{
\item{x}{The data obtained by function \code{\link{generateCowbell}}.}

\item{breakPointUsed}{Defaults to TRUE and indicates if we want to use the version with breakpoint (or not).}

\item{...}{Just for compatibility purposes.}
}
\description{
Generates a three dimension plot of cowbell function. Additionally the data points of the original data set are added
in the visualization. The function with and without breaking point can be visualized.
Implementation of the \code{\link{plot}} generic.
}
\examples{
# Run a simplified anaylsis with 10 iterations only (to save time.)
concept<-generateCowbellConcept(Fun ~ Fluency * Absorption, 1, 9, 1, 7, 1, 7)
data(allFun)
test<-generateCowbell(concept, allFun, 10)
plot(test)
}
