% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/build_network.R
\name{build_network.cranly_db}
\alias{build_network.cranly_db}
\alias{cranly_network}
\alias{build_network}
\title{Compute edges and nodes of package directives and collaboration networks}
\usage{
\method{build_network}{cranly_db}(object, trace = FALSE, perspective = "package", ...)
}
\arguments{
\item{object}{a \code{\link{cranly_db}} object. If missing (default) a call to \code{\link[=clean_CRAN_db]{clean_CRAN_db()}} is issued.}

\item{trace}{logical. Print progress information? Default is \code{\link{FALSE}}.}

\item{perspective}{character. Should a \code{"package"} (default) or an \code{"author"} network be built?}

\item{...}{Other arguments passed in \code{\link[=clean_CRAN_db]{clean_CRAN_db()}} when \code{object} is \code{NULL}.}
}
\value{
A list of 2 \code{\link{data.frame}} objects with the \code{edges} and \code{nodes} of the network.
}
\description{
Compute edges and nodes of package directives and collaboration networks
}
\details{
The convention for a \code{\link{cranly_network}} object with
\code{perspective = "package"} is that the direction of an edge is
from the package that is imported by, suggested by, enhances or is
a dependency of another package, to the latter package. The author
collaboration network is analyzed and visualized as undirected by
all methods in \code{cranly}.
}
\examples{
\donttest{
cran_db <- clean_CRAN_db()

## Build package directives network
package_network <- build_network(object = cran_db, perspective = "package")
head(package_network$edges)
head(package_network$nodes)
attr(package_network, "timestamp")
class(package_network)

## Build author collaboration network
author_network <- build_network(object = cran_db, perspective = "author")
head(author_network$edges)
head(author_network$nodes)
attr(author_network, "timestamp")
class(author_network)
}

}
\seealso{
\code{\link[=clean_CRAN_db]{clean_CRAN_db()}} \code{\link[=subset.cranly_network]{subset.cranly_network()}} \code{\link[=plot.cranly_network]{plot.cranly_network()}} \code{\link{extractor-functions}}
}
