% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/data-documentation.R
\name{NCAdata_tbl_df}
\alias{NCAdata_tbl_df}
\title{Interim Dane Data with New Criminal Activity (NCA)}
\format{
A tibble with 1,891 observations and 19 variables:
\describe{
  \item{Sex}{Numeric variable representing the individual's sex.}
  \item{White}{Numeric variable indicating whether the individual is White.}
  \item{SexWhite}{Numeric interaction term between Sex and White.}
  \item{Age}{Numeric variable indicating the individual's age.}
  \item{PendingChargeAtTimeOfOffense}{Numeric variable indicating if there was a pending charge at the time of offense.}
  \item{NCorNonViolentMisdemeanorCharge}{Numeric variable indicating a non-violent misdemeanor charge.}
  \item{ViolentMisdemeanorCharge}{Numeric variable indicating a violent misdemeanor charge.}
  \item{ViolentFelonyCharge}{Numeric variable indicating a violent felony charge.}
  \item{NonViolentFelonyCharge}{Numeric variable indicating a non-violent felony charge.}
  \item{PriorMisdemeanorConviction}{Numeric variable indicating prior misdemeanor convictions.}
  \item{PriorFelonyConviction}{Numeric variable indicating prior felony convictions.}
  \item{PriorViolentConviction}{Numeric variable indicating prior violent convictions.}
  \item{PriorSentenceToIncarceration}{Numeric variable indicating prior sentences to incarceration.}
  \item{PriorFTAInPastTwoYears}{Numeric variable indicating prior failures to appear (FTA) in the past two years.}
  \item{PriorFTAOlderThanTwoYears}{Numeric variable indicating prior failures to appear (FTA) older than two years.}
  \item{Staff_ReleaseRecommendation}{Numeric variable indicating the staff release recommendation.}
  \item{Z}{Binary treatment variable.}
  \item{D}{Ordinal decision variable.}
  \item{Y}{Outcome variable measuring new criminal activity (NCA).}
}
}
\source{
Interim Dane data with new criminal activity (NCA) as an outcome.
}
\usage{
data(NCAdata_tbl_df)
}
\description{
This dataset contains pre-treatment covariates, a binary treatment (Z),
an ordinal decision (D), and an outcome variable (Y). It is used to study
new criminal activity (NCA).
}
\details{
The dataset name has been changed to 'NCAdata_tbl_df' to avoid confusion with other data sets
in the R ecosystem. This naming convention helps distinguish this dataset as part of the
crimedatasets package and assists users in identifying its specific characteristics.
The suffix 'tbl_df' indicates that the dataset is a tibble in R. The original content has
not been modified in any way.
}
