% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/data-documentation.R
\name{corruption_tbl_df}
\alias{corruption_tbl_df}
\title{China's Corruption Investigations}
\format{
A tibble with 10 observations and 6 variables:
\describe{
  \item{province}{2-digit province number (numeric).}
  \item{prefecture}{Prefecture name in Chinese (character).}
  \item{county}{County name in Chinese (character).}
  \item{province_id}{6-digit province identifier (numeric).}
  \item{prefecture_id}{6-digit prefecture identifier (numeric).}
  \item{county_id}{6-digit county identifier (numeric).}
}
}
\source{
Data from China's anti-corruption campaign investigations.
}
\usage{
data(corruption_tbl_df)
}
\description{
This dataset contains information on nearly 20,000 officials who were investigated during Xi Jinping's
anti-corruption campaign. It provides data on the province, prefecture, and county where the investigations
occurred, as well as unique identifiers for each administrative level.
}
\details{
The dataset name has been changed to 'corruption_tbl_df' to avoid confusion with other data sets
in the R ecosystem. This naming convention helps distinguish this dataset as part of the crimedatasets package
and assists users in identifying its specific characteristics. The suffix 'tbl_df' indicates that the dataset
is a tibble in R. The original content has not been modified in any way
}
