% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/phase_three_library.R
\name{makePhaseThreeImList}
\alias{makePhaseThreeImList}
\title{Make phase 3 im list from phase 2 im list}
\usage{
makePhaseThreeImList(D, Q, rm.ordered, til.ee, pool.sizes, max.stored,
  max.nrs.borrow, shouldPrint)
}
\arguments{
\item{D}{binary matrix of events by samples}

\item{Q}{penalty matrix of events by samples}

\item{rm.ordered}{matrix of rules ordered by phase one}

\item{til.ee}{list of rule set matrices (im list) from phase two}

\item{pool.sizes}{pool sizes for phase two}

\item{max.stored}{max number of rule sets saved}

\item{max.nrs.borrow}{max number of new rule sets per k, default is 10^5}

\item{shouldPrint}{Print progress updates? Default is TRUE}
}
\value{
phase 3 top im list
}
\description{
Make phase 3 im list from phase 2 im list
}
\examples{
library(crso)
data(skcm)
list2env(skcm.list,envir=globalenv())
Q <- log10(P)
rm.full <- buildRuleLibrary(D,rule.thresh = 0.05) # Rule library matrix, dimension: 60 x 71
til.p2 <- makePhaseTwoImList(D,Q,rm.full,k.max = 3,pool.sizes=c(60,10,10),
          max.stored=100,shouldPrint = FALSE)
til.p3 <- makePhaseThreeImList(D,Q,rm.ordered = rm.full,til.ee = til.p2, pool.sizes=c(60,20,20),
         max.stored=100,max.nrs.borrow=100,shouldPrint = TRUE)
}
