% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/phase_two_library.R
\name{makePhaseTwoImList}
\alias{makePhaseTwoImList}
\title{Output list of top rule sets for each k in 1:k.max}
\usage{
makePhaseTwoImList(D, Q, rm.ordered, k.max, pool.sizes, max.stored,
  shouldPrint)
}
\arguments{
\item{D}{binary matrix of events by samples}

\item{Q}{penalty matrix of events by samples}

\item{rm.ordered}{matrix of rules ordered by phase one}

\item{k.max}{max k}

\item{pool.sizes}{vector of the number of top rules evaluated for each k}

\item{max.stored}{max number of rule sets saved}

\item{shouldPrint}{Print progress updates? Default is TRUE}
}
\value{
largest n such that n choose k < max.num.rs
}
\description{
Output list of top rule sets for each k in 1:k.max
}
\examples{
library(crso)
data(skcm)
list2env(skcm.list,envir=globalenv())
Q <- log10(P)
rm.full <- buildRuleLibrary(D,rule.thresh = 0.05) # Rule library matrix, dimension: 60 x 71
til.p2 <- makePhaseTwoImList(D,Q,rm.full,k.max = 3,
         pool.sizes=c(60,20,20),max.stored=100,shouldPrint = TRUE)
}
