% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/coinmarketcap.R
\name{coinmarketcap_category}
\alias{coinmarketcap_category}
\title{coinmarketcap_category}
\usage{
coinmarketcap_category(
  api_key,
  id,
  start = "1",
  limit = NULL,
  convert = NULL,
  convert_id = NULL,
  timeout_seconds = 60
)
}
\arguments{
\item{api_key}{your CoinMarketCap API key}

\item{id}{the category id you wish to query.}

\item{start}{you can use this parameter to offset your first result. The
default value is "1".}

\item{limit}{an optional string value between 1 and 5000 which tells
CoinMarketCap how many results to return. The default value is NULL.}

\item{convert}{Optionally calculate market quotes in up to 120 currencies at
once by passing a comma-separated list of cryptocurrency or fiat currency
symbols.}

\item{convert_id}{Optionally calculate market quotes by CoinMarketCap id
instead of symbol.}

\item{timeout_seconds}{seconds until the query times out. Default is 60.}
}
\value{
returns a list with information about the specified category.
}
\description{
coinmarketcap_category
}
\examples{
\dontrun{
api_key <- "..."
id <- "6363a6c9cd197958bb543bf0"
category <- coinmarketcap_category(api_key, id)}
}
