% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/r6_DBConnection_v9.R
\name{DBConnection_v9}
\alias{DBConnection_v9}
\title{R6 Class representing a database connection}
\description{
A robust database connection manager that handles connections to various database systems
including Microsoft SQL Server and PostgreSQL. This class provides connection management,
authentication, and automatic reconnection capabilities.
}
\details{
The DBConnection_v9 class encapsulates database connection logic and provides a consistent
interface for connecting to different database systems. It supports both trusted connections
and user/password authentication, handles connection failures gracefully, and provides
automatic reconnection functionality.

Key features:
\itemize{
  \item Support for multiple database systems (SQL Server, PostgreSQL)
  \item Automatic connection management with retry logic
  \item Secure credential handling
  \item Connection status monitoring
  \item Graceful error handling and recovery
}
}
\examples{
\dontrun{
# Create a SQL Server connection
db_config <- DBConnection_v9$new(
  driver = "ODBC Driver 17 for SQL Server",
  server = "localhost",
  port = 1433,
  db = "mydb",
  user = "myuser",
  password = "mypass"
)

# Connect to the database
db_config$connect()

# Check connection status
db_config$is_connected()

# Use the connection
tables <- DBI::dbListTables(db_config$connection)

# Disconnect when done
db_config$disconnect()

# PostgreSQL example
pg_config <- DBConnection_v9$new(
  driver = "PostgreSQL",
  server = "localhost",
  port = 5432,
  db = "mydb",
  user = "myuser",
  password = "mypass"
)

pg_config$connect()
# ... use connection ...
pg_config$disconnect()
}
}
\section{Public fields}{
\if{html}{\out{<div class="r6-fields">}}
\describe{
\item{\code{config}}{Configuration details of the database.}
}
\if{html}{\out{</div>}}
}
\section{Active bindings}{
\if{html}{\out{<div class="r6-active-bindings">}}
\describe{
\item{\code{connection}}{Database connection.}

\item{\code{autoconnection}}{Database connection that automatically connects if possible.}
}
\if{html}{\out{</div>}}
}
\section{Methods}{
\subsection{Public methods}{
\itemize{
\item \href{#method-DBConnection_v9-new}{\code{DBConnection_v9$new()}}
\item \href{#method-DBConnection_v9-is_connected}{\code{DBConnection_v9$is_connected()}}
\item \href{#method-DBConnection_v9-print}{\code{DBConnection_v9$print()}}
\item \href{#method-DBConnection_v9-connect}{\code{DBConnection_v9$connect()}}
\item \href{#method-DBConnection_v9-disconnect}{\code{DBConnection_v9$disconnect()}}
\item \href{#method-DBConnection_v9-clone}{\code{DBConnection_v9$clone()}}
}
}
\if{html}{\out{<hr>}}
\if{html}{\out{<a id="method-DBConnection_v9-new"></a>}}
\if{latex}{\out{\hypertarget{method-DBConnection_v9-new}{}}}
\subsection{Method \code{new()}}{
Create a new DBConnection_v9 object.
\subsection{Usage}{
\if{html}{\out{<div class="r">}}\preformatted{DBConnection_v9$new(
  driver = NULL,
  server = NULL,
  port = NULL,
  db = NULL,
  schema = NULL,
  user = NULL,
  password = NULL,
  trusted_connection = NULL,
  sslmode = NULL,
  role_create_table = NULL
)}\if{html}{\out{</div>}}
}

\subsection{Arguments}{
\if{html}{\out{<div class="arguments">}}
\describe{
\item{\code{driver}}{Driver}

\item{\code{server}}{Server}

\item{\code{port}}{Port}

\item{\code{db}}{DB}

\item{\code{schema}}{Schema (e.g. "dbo")}

\item{\code{user}}{User}

\item{\code{password}}{Password}

\item{\code{trusted_connection}}{NULL or "yes"}

\item{\code{sslmode}}{NULL or "require"}

\item{\code{role_create_table}}{NULL or the role to take when creating tables.}
}
\if{html}{\out{</div>}}
}
\subsection{Returns}{
A new `DBConnection_v9` object.
}
}
\if{html}{\out{<hr>}}
\if{html}{\out{<a id="method-DBConnection_v9-is_connected"></a>}}
\if{latex}{\out{\hypertarget{method-DBConnection_v9-is_connected}{}}}
\subsection{Method \code{is_connected()}}{
Is the DB schema connected?
\subsection{Usage}{
\if{html}{\out{<div class="r">}}\preformatted{DBConnection_v9$is_connected()}\if{html}{\out{</div>}}
}

\subsection{Returns}{
TRUE/FALSE
}
}
\if{html}{\out{<hr>}}
\if{html}{\out{<a id="method-DBConnection_v9-print"></a>}}
\if{latex}{\out{\hypertarget{method-DBConnection_v9-print}{}}}
\subsection{Method \code{print()}}{
Class-specific print function.
\subsection{Usage}{
\if{html}{\out{<div class="r">}}\preformatted{DBConnection_v9$print(...)}\if{html}{\out{</div>}}
}

\subsection{Arguments}{
\if{html}{\out{<div class="arguments">}}
\describe{
\item{\code{...}}{Not used.}
}
\if{html}{\out{</div>}}
}
}
\if{html}{\out{<hr>}}
\if{html}{\out{<a id="method-DBConnection_v9-connect"></a>}}
\if{latex}{\out{\hypertarget{method-DBConnection_v9-connect}{}}}
\subsection{Method \code{connect()}}{
Connect to the database
\subsection{Usage}{
\if{html}{\out{<div class="r">}}\preformatted{DBConnection_v9$connect(attempts = 2)}\if{html}{\out{</div>}}
}

\subsection{Arguments}{
\if{html}{\out{<div class="arguments">}}
\describe{
\item{\code{attempts}}{Number of attempts to be made to try to connect}
}
\if{html}{\out{</div>}}
}
}
\if{html}{\out{<hr>}}
\if{html}{\out{<a id="method-DBConnection_v9-disconnect"></a>}}
\if{latex}{\out{\hypertarget{method-DBConnection_v9-disconnect}{}}}
\subsection{Method \code{disconnect()}}{
Disconnect from the database
\subsection{Usage}{
\if{html}{\out{<div class="r">}}\preformatted{DBConnection_v9$disconnect()}\if{html}{\out{</div>}}
}

}
\if{html}{\out{<hr>}}
\if{html}{\out{<a id="method-DBConnection_v9-clone"></a>}}
\if{latex}{\out{\hypertarget{method-DBConnection_v9-clone}{}}}
\subsection{Method \code{clone()}}{
The objects of this class are cloneable with this method.
\subsection{Usage}{
\if{html}{\out{<div class="r">}}\preformatted{DBConnection_v9$clone(deep = FALSE)}\if{html}{\out{</div>}}
}

\subsection{Arguments}{
\if{html}{\out{<div class="arguments">}}
\describe{
\item{\code{deep}}{Whether to make a deep clone.}
}
\if{html}{\out{</div>}}
}
}
}
