% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/cterFit.R
\name{cterFit}
\alias{cterFit}
\title{Fit the continuous threshold expectile regression}
\usage{
cterFit(y, x, z, tau = 0.5, max.iter = 100, tol = 1e-04)
}
\arguments{
\item{y}{A vector of response}

\item{x}{A scalar covariate with threshold}

\item{z}{A vector of covariates}

\item{tau}{the expectile level, 0.5 for default}

\item{max.iter}{the maximum iteration steps, 100 for default}

\item{tol}{tolerance value, 1e-4 for default}
}
\value{
A list with the elements
\item{coef.est}{The estimated regression coefficients with intercept.}
\item{threshold.est}{The estimated threshold.}
\item{coef.se}{The estimated standard error of the regression coefficients.}
\item{threshold.se}{The estimated standard error of the threshold.}
\item{iter}{The iteration steps.}
}
\description{
The grid search algorithm for the continuous threshold expectile regression
}
\examples{


## simulated data
ptm <- proc.time()
n <- 200
t0 <- 1.5
bet0 <- c(1, 3, -2, 1)
tau <- 0.3
modtype <- 1
errtype <- 1
dat <- cterSimData(n, bet0, t0, tau, modtype, errtype)
y <- dat[, 1]
x <- dat[, 2]
z <- dat[, 3]
fit <- cterFit(y, x, z, tau)

## The example of Baseball pitcher salary
data(data_bbsalaries)
y <- data_bbsalaries$y
x <- data_bbsalaries$x
z <- NULL
tau <- 0.5
fit <- cterFit(y, x, z, tau)
proc.time() - ptm
}
\author{
Feipeng Zhang and Qunhua Li
}
\keyword{cterFit}

