% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/ctModelFromFit.R
\name{ctModelFromFit}
\alias{ctModelFromFit}
\title{Extract a ctsem model structure with parameter values from a ctsem fit object.}
\usage{
ctModelFromFit(fit)
}
\arguments{
\item{fit}{object output by \code{\link[ctsemOMX]{ctFit}}}
}
\value{
object of class 'ctsemInit' (as generated by \code{\link[ctsem]{ctModel}}), 
which can be used with \code{\link[ctsemOMX]{ctFit}} and functions.
}
\description{
Extract a ctsem model structure with parameter values from a ctsem fit object.
}
\examples{
data(AnomAuth) 
AnomAuthmodel <- ctModel(LAMBDA = matrix(c(1, 0, 0, 1), nrow = 2, ncol = 2), 
  Tpoints = 5, n.latent = 2, n.manifest = 2, MANIFESTVAR=diag(0, 2)) 
AnomAuthfit <- ctFit(AnomAuth, AnomAuthmodel)

fitmodel <- ctModelFromFit(AnomAuthfit)
}
