% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/chemical-APIs.R
\name{chemical_equal}
\alias{chemical_equal}
\title{Chemical equal}
\usage{
chemical_equal(
  word = NULL,
  API_key = NULL,
  Server = chemical_api_server,
  verbose = FALSE
)
}
\arguments{
\item{word}{A character string of a chemical identifier or portion of a chemical
identifier. Identifiers can be a chemical name, dtxsid, dtxcid, casrn, or inchikey.}

\item{API_key}{The user-specific API key}

\item{Server}{The root address for the API endpoint}

\item{verbose}{A logical indicating if some “progress report” should be given.}
}
\value{
A data.frame of chemicals and related values matching the query
parameters
}
\description{
Chemical equal
}
\examples{
\dontshow{if (has_ctx_key() & is.na(ctx_key() == 'FAKE_KEY')) withAutoprint(\{ # examplesIf}
# Pull chemicals with matching DTXSID
bpa_dtxsid <- chemical_equal(word = 'DTXSID7020182')
\dontshow{\}) # examplesIf}
}
\author{
Paul Kruse, Kristin Issacs
}
