% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/test.R
\name{run}
\alias{run}
\title{Run Cucumber tests in a \code{testthat} context}
\usage{
run(path = ".", filter = NULL, ...)
}
\arguments{
\item{path}{Path to the directory containing the \code{.feature} files.
If \code{run()} is placed in a \verb{tests/testthat/test-*.R} file and you call \code{testthat::test_dir} or similar,
it runs in the \code{tests/testthat} directory. The default value \code{"."} finds all feature
files in the \code{tests/testthat} directory.}

\item{filter}{If not NULL, only features with file names matching this regular expression
will be executed. Matching is performed on the file name after it's stripped of ".feature".}

\item{...}{Additional arguments passed to \code{grepl()}.}
}
\value{
NULL, invisibly.
To get result and a report, use \code{cucumber::test()}, or inspect the result of \code{testthat} function call.
}
\description{
It's purpose is to be able to run Cucumber tests alongside \code{testthat} tests.

To do that, place a call to \code{run()} in one of the \verb{test-*.R} files in your \code{tests/testthat} directory.
}
\examples{
\dontrun{
#' tests/testthat/test-cucumber.R
cucumber::run()
}

}
