% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/partial.R
\name{partial}
\alias{\%><\%}
\alias{partial}
\title{Apply arguments partially to a function}
\usage{
fun \%><\% args

partial(fun, args)
}
\arguments{
\item{fun}{A function to be partially applied. Can be any function (normal,
already partially applied, primitives).}

\item{args}{A list of values that should be applied to the function.}
}
\value{
A function with the same arguments as \code{fun} except for the ones
given in \code{args}
}
\description{
The \code{partial} function and the \code{\%><\%} operator allows you to
partially call a function with a list of arguments. Named elements in the
list will be matched to function arguments and these arguments will be
removed from the returned function. Unnamed elements are only allowed for
functions containing an ellipsis, in which case they are considered part of
the ellipsis.
}
\note{
Multiple partial application does not result in multiple nested calls,
so while the first partial call adds a layer around the called function,
potentially adding a very small performance hit, partially calling multiple
times will not add to this effect.
}
\examples{
dummy_lengths <- vapply \%><\% list(FUN = length, FUN.VALUE = integer(1))
test_list <- list(a = 1:5, b = 1:10)
dummy_lengths(test_list)

}
\seealso{
Other partials: \code{\link{curry}},
  \code{\link{tail_curry}}
}

