% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/8-Draw.R
\name{box_at}
\alias{box_at}
\title{Draw Box}
\usage{
box_at(
  yx = c(1, 1),
  dim = NULL,
  text = c("|", "|", "-", "-", rep("+", 4)),
  fg = NA,
  bg = NA,
  attr = NA,
  fill = NA,
  fill.bg = NA,
  fill.fg = NA,
  fill.attr = NA
)
}
\arguments{
\item{yx}{starting console row and column of top-left corner of box}

\item{dim}{box dimensions in \code{c(height, width)}. If \code{NA}, defaults to the terminal's screen width.}

\item{text}{repeated character used for box. \code{text} can either be a single character or a vector of 8 characters (left side, right side, top, bottom, 4 corners: upper left, upper right, lower left, lower right).}

\item{fg}{foreground color. See \code{\link{fg_on}} for more details.}

\item{bg}{background color. See \code{\link{bg_on}} for more details.}

\item{attr}{border text attributes. See \code{\link{attr_on}} for details.}

\item{fill}{character object to fill box. Only the first character in the first element is used. If \code{NA} (the default), the box is not filled.}

\item{fill.bg}{background color of the fill character.}

\item{fill.fg}{foreground color of the fill character.}

\item{fill.attr}{text attributes of the fill character.}
}
\value{
\code{NULL}
}
\description{
Draws a box of size \code{dim=c(height, width)} at \code{yx=c(row,col)}.
}
\examples{
box_at(yx=c(4,4), dim=c(5,10), text="X")

}
\seealso{
Other drawing functions: 
\code{\link{draw_arc}()},
\code{\link{draw_bezier}()},
\code{\link{draw_circle}()},
\code{\link{draw_ellipse}()},
\code{\link{draw_fn}()},
\code{\link{draw_lerp}()},
\code{\link{draw_path}()},
\code{\link{draw_ray}()},
\code{\link{draw_rect}()},
\code{\link{draw_shape}()},
\code{\link{fill_circle}()},
\code{\link{fill_ellipse}()},
\code{\link{fill_rect}()},
\code{\link{fill_shape}()},
\code{\link{grid_at}()},
\code{\link{grid_mat}()},
\code{\link{hline_at}()},
\code{\link{hline}()},
\code{\link{vline_at}()},
\code{\link{vline}()}
}
\concept{drawing functions}
