% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/5-Write.R
\name{wrat}
\alias{wrat}
\title{Write At a Specific Location}
\usage{
wrat(yx, text, ...)
}
\arguments{
\item{yx}{numeric vector specifying the \code{(row, col)} coordinates to print at}

\item{text}{text to be written at \code{yx}}

\item{...}{colors and attributes added to text. See \code{\link{wr}}, \code{\link{fg_on}}, \code{\link{bg_on}}, and \code{\link{attr_on}} for more details.}
}
\value{
\code{NULL}
}
\description{
Move cursor to specified location in the terminal screen, then print the supplied text. This function will only work in terminal, not the RStudio Console or R GUI.
}
\details{
The coordinates are given in matrix notation: \code{(row, column)}, with the top-left corner of the screen being \code{(1,1)}.
}
\examples{
wrat(c(10,6), "CURSR")
wrat(c(4,1), "Hello World!", fg="red", attr=c("bf", "ul"))

mat <- rbind(c(5,2), c(10,5), c(1,19))
wrat(mat, "HI", fg="yellow")

}
\seealso{
Other writing functions: 
\code{\link{wrch}()},
\code{\link{wrkpl}()},
\code{\link{wrkp}()},
\code{\link{wr}()}
}
\concept{writing functions}
