% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/cp_est.R
\name{cp_est}
\alias{cp_est}
\title{Estimate cutpoints in a multivariable setting for survival data}
\usage{
cp_est(
  cpvarname,
  time = "time",
  event = "event",
  covariates = NULL,
  data = data,
  nb_of_cp = 1,
  bandwith = 0.1,
  est_type = "AIC",
  cpvar_strata = FALSE,
  ushape = FALSE,
  symtails = FALSE,
  dp = 2,
  plot_splines = TRUE,
  all_splines = TRUE,
  print_res = TRUE,
  verbose = TRUE
)
}
\arguments{
\item{cpvarname}{character, the name of the variable for which the cutpoints
are estimated.}

\item{time}{character, this is the follow-up time.}

\item{event}{character, the status indicator, normally 0=no event, 1=event}

\item{covariates}{character vector with the names of the covariates and/ or
factors. If no covariates are used, set \code{covariates = NULL}.}

\item{data}{a data.frame, contains the following variables:
\itemize{
\item variable which is dichotomized
\item follow-up time
\item event (status indicator)
\item covariates and/or cofactors
}}

\item{nb_of_cp}{numeric, number of cutpoints to be estimated (1 or 2). The
default is: \code{nb_of_cp = 1}. The other option is \code{nb_of_cp = 2}.}

\item{bandwith}{numeric, minimum group size per group in percent of the total
sample size, \code{bandwith} must be between 0.05 and 0.30, default is 0.1
If \code{ushape = TRUE}, \code{bandwidth} must be at least 0.1.}

\item{est_type}{character, the method used to estimate the cutpoints. The
default is 'AIC' (Akaike information criterion). The other options is 'LRT'
(likelihood ratio test statistic)}

\item{cpvar_strata}{logical value: if \code{FALSE}, The dichotomised variable
serves as covariate in the Cox-regression model for cutpoint determination.
If \code{TRUE}, the dichotomised variable is included as a strata in the
Cox-regression model to determine the cutpoint rather than as a covariate.
Default is \code{FALSE}.}

\item{ushape}{logical value: if \code{TRUE}, the cutpoints are estimated under the
assumtion that the spline plot shows a U-shaped form or a inverted U-shaped
curve. Default is \code{FALSE}.}

\item{symtails}{logical value: if \code{TRUE}, the cutpoints are estimated with
symmetric tails. If \code{nb_of_cp = 1}, symtails is set to \code{FALSE}. Default is
\code{FALSE}.}

\item{dp}{numeric, number of decimal places the cutpoints are rounded to.
Default is \code{dp = 2}.}

\item{plot_splines}{logical value: if \code{TRUE}, a penalized spline plot is
created. Default is \code{TRUE}.}

\item{all_splines}{logical value: if \code{TRUE}, The plot shows splines with
different degrees of freedom. This may help determine whether
misspecification or overfitting occurs. Default is \code{TRUE}.}

\item{print_res}{logical value: if \code{TRUE} the function prints the summary
of the cutpoint estimation to the console. Default is \code{TRUE}.}

\item{verbose}{logical value: if \code{TRUE} the function prints the approximate
remaining process-time and other information to the console. If \code{FALSE}, no
information will be printed to the console, including the summary of the
cutpoint estimation. Default is \code{TRUE}.}
}
\value{
Returns the \code{cpobj} object with cutpoints and the characteristics
of the formed groups.
}
\description{
One or two cutpoints of a metric variable are estimated using
either the AIC (Akaike Information Criterion) or the LRT
(Likelihood-Ratio Test statistic) within a multivariable Cox proportional
hazards model. These cutpoints are used to create two or three groups with
different survival probabilities.

The cutpoints are estimated by dichotomising the variable of
interest, which is then incorporated into the Cox regression model. The
cutpoint of this variable is the value at which the AIC reaches its lowest
value or the LRT statistic achieves its maximum for the corresponding
Cox-regression model.

This process occurs within a multivariable framework, as other
covariates and/or factors are considered during the search for the
cutpoints. Cutpoints can also be estimated when the variable of interest
shows a U-shaped or inverse U-shaped relationship to the hazard ratio of
time-to-event data. The argument \code{symtail} facilitates the estimation of two
cutpoints, ensuring that the two outer tails represent groups of equal size.
}
\examples{
\donttest{
# Example 1:
# Estimate two cutpoints of the variable biomarker.
# The dataset data1 is included in this package and contains
# the variables time, event, biomarker, covariate_1, and covariate_2.
cpobj <- cp_est(
  cpvarname  = "biomarker",
  covariates = c("covariate_1", "covariate_2"),
  data       = data1,
  nb_of_cp   = 2,
  plot_splines = FALSE
  )

# Example 2:
# Searching for cutpoints, if the variable shows a U-shaped or
# inverted U-shaped relationship to the hazard ratio.
# The dataset data2_ushape is included in this package and contains
# the variables time, event, biomarker, and cutpoint_1.
cpobj <- cp_est(
  cpvarname  = "biomarker",
  covariates = c("covariate_1"),
  data       = data2_ushape,
  nb_of_cp   = 2,
  bandwith   = 0.2,
  ushape     = TRUE,
  plot_splines = FALSE
  )
  }
}
\references{
Govindarajulu, U., & Tarpey, T. (2020). Optimal partitioning for
the proportional hazards model. Journal of Applied Statistics, 49(4),
968–987. https://doi.org/10.1080/02664763.2020.1846690
}
\seealso{
\code{\link[=cp_splines_plot]{cp_splines_plot()}} for penalized spline plots, \code{\link[=cp_value_plot]{cp_value_plot()}}
for Value plots and Index plots
}
