% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/cp_estsum.R
\name{cp_estsum}
\alias{cp_estsum}
\title{Summarise cutpoint estimation}
\usage{
cp_estsum(cpobj, verbose = TRUE)
}
\arguments{
\item{cpobj}{list, contains variables for \code{cp_estsum} function}

\item{verbose}{logical value: if \code{TRUE} the summary of the cutpoint
estimation is writing to the console. Default is \code{TRUE}.}
}
\value{
Summary of the cutpoint estimation.
}
\description{
Writes the summary of the cutpoint estimation to the console.
}
\examples{
\donttest{
# Example
# Writes the summary to the console
# The data set data1 is included in this package
cpobj <- cp_est(
  cpvarname    = "biomarker",
  covariates   = c("covariate_1", "covariate_2"),
  data         = data1,
  nb_of_cp     = 2,
  plot_splines = FALSE,
  print_res    = FALSE
)
cp_estsum(cpobj, verbose = TRUE)
}
}
\seealso{
\code{\link[=cp_est]{cp_est()}} for main function of the package.
}
