% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/model-algae.R
\name{Algae-models}
\alias{Algae-models}
\alias{Algae-class}
\title{Algae models}
\description{
Overview of supported \emph{Algae} models
}
\details{
\itemize{
\item \code{\link[=Algae_Weber]{Algae_Weber()}} by Weber \emph{et al.} (2012)
\item \code{\link[=Algae_TKTD]{Algae_TKTD()}} based on Weber \emph{et al.} (2012), but with scaled damage
\item \code{\link[=Algae_Simple]{Algae_Simple()}} simplified growth model without additional forcing variables
}
}
\section{Biomass transfer}{

Models supporting biomass transfer can be instructed to move a fixed amount
of biomass to a new medium after a period of time. This feature replicates
a procedure occurring in e.g. \emph{Lemna} effect studies and may be necessary to
recreate study results.

The biomass transfer feature assumes that always a fixed amount of
biomass is transferred. Transfers can occur at any fixed point in time or
in regular intervals. During a transfer, the biomass is reset to the
transferred amount and additional compartments can be scaled 1:1 accordingly,
to e.g. reflect the change in internal toxicant mass when biomass is modified.
Transfer settings can be modified using \code{\link[=set_transfer]{set_transfer()}}.

If a transfer occurs, simulation results of that time point will report the model state
\strong{before} the transfer. Be aware that if transfers are defined using the
\code{interval} argument, the transfers will always occur relative to time point
zero (\code{t = 0}). As an example, setting a regular transfer of seven days,
\code{interval =  7}, will result at transfers occurring at time points which are
integer multiplicates of seven, such as \code{t=0}, \code{t=7}, \code{t=14} and so forth.
The starting and end times of a scenario do not influece \strong{when} a regular
transfer occurs, only \strong{if} it occurs.
}

\references{
Weber D, Schaefer D, Dorgerloh M, Bruns E, Goerlitz G, Hammel K, Preuss TG
and Ratte HT, 2012. Combination of a higher-tier flow-through system and
population modeling to assess the effects of time-variable exposure of
isoproturon on the green algae Desmodesmus subspictatus and
Pseudokirchneriella subcapitata. Environmental Toxicology and
Chemistry, 31(4), 899-908. \doi{10.1002/etc.1765}

EFSA Panel on Plant Protection Products and their Residues, 2018. Scientific
opinion on the state of the art of Toxicokinetic/Toxicodynamic (TKTD) effect
models for regulatory risk assessment of pesticides for aquatic organisms.
EFSA journal 16:5377 \doi{10.2903/j.efsa.2018.5377}
}
\seealso{
\link{Lemna-models}, \link{Transferable}

Other algae models: 
\code{\link{Algae_Simple}()},
\code{\link{Algae_TKTD}()},
\code{\link{Algae_Weber}()}

Other models: 
\code{\link{DEB-models}},
\code{\link{GUTS-RED-models}},
\code{\link{Lemna-models}},
\code{\link{Macrophyte-models}}
}
\concept{algae models}
\concept{models}
