% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/calculate_densities.R
\name{calculate_densities}
\alias{calculate_densities}
\title{Obtain species densities from transition matrices}
\usage{
calculate_densities(focal.sp, vpm, current.densities)
}
\arguments{
\item{focal.sp}{integer, focal species}

\item{vpm}{data structure holding all vector-permutation matrices; see 
`vec_permutation_matrices`. If not in an appropriate format, it is likely
to fail without warning.}

\item{current.densities}{list of length sp, each element is a matrix sites*stages. If
not in that format, it is likely to fail without warning.}
}
\value{
matrix of sites x stages, each element is the density of a given life stage
(juvenile, non-reproductive adult, reproductive adult) at a given site.
}
\description{
Using the vec-permutation approach as defined in: 
Hunter and Caswell 2005, doi:10.1016/j.ecolmodel.2005.05.002, 
Ozgul et al. 2009, doi: 10.1086/597225
In particular, it uses the arrangement by patches, and calculates
first demography, then dispersal (Table 1 of Hunter and Caswell 2005).
}
