% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/datadocumentation.R
\docType{data}
\name{wah_morts}
\alias{wah_morts}
\title{Mortality data for Western Arctic Herd Caribou}
\format{
Data frame with 171 rows and the following columns:
\describe{
  \item{id}{ID of animal}
  \item{start}{Date of beginning of collaring}
  \item{end}{Date of death or censoring}
  \item{fate}{One of "dead", or "censored"}
}
}
\source{
U.S. National Park Service, Alaska
}
\usage{
data(wah_morts)
}
\description{
Anonymized mortality data on Western Arctic Herd caribou collected by the 
U.S. National Park Service, Alaska, with grateful acknowledgments to K. Joly.
}
\examples{
data(wah_morts)
require(ggplot2); require(magrittr); require(plyr)
ggplot(wah_morts \%>\% arrange(start),
aes(x = start, y = id, col = fate)) + 
  geom_errorbarh(aes(xmin = start, xmax = end))

}
\keyword{data}
