% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/svd_entropy.R
\name{svd_entropy}
\alias{svd_entropy}
\title{Feature importance based on data entropy.}
\usage{
svd_entropy(variables, sample, cores = NULL)
}
\arguments{
\item{variables}{character vector specifying observation variables.}

\item{sample}{tbl containing sample used to estimate parameters.}

\item{cores}{optional integer specifying number of CPU cores used for parallel computing using \code{doParallel}.}
}
\value{
data frame specifying the contribution of each feature in decreasing the data entropy.
Higher values indicate more information.
}
\description{
\code{svd_entropy} measures the contribution of each feature in decreasing the data entropy.
}
\examples{
sample <- tibble::tibble(
  AreaShape_MinorAxisLength = c(10, 12, 15, 16, 8, 8, 7, 7, 13, 18),
  AreaShape_MajorAxisLength = c(35, 18, 22, 16, 9, 20, 11, 15, 18, 42),
  AreaShape_Area = c(245, 151, 231, 179, 50, 112, 53, 73, 164, 529)
)
variables <- c("AreaShape_MinorAxisLength", "AreaShape_MajorAxisLength", "AreaShape_Area")
svd_entropy(variables, sample, cores = 1)
}
