% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/core_dm.R
\name{comp_vals}
\alias{comp_vals}
\title{Evaluate all Component Functions}
\usage{
comp_vals(
  drift_dm_obj,
  x_vec = NULL,
  t_vec = NULL,
  nt = NULL,
  dt = NULL,
  nx = NULL,
  dx = NULL,
  prms_solve = NULL,
  solver = NULL,
  prms_matrix = NULL
)
}
\arguments{
\item{drift_dm_obj}{an object of type \link{drift_dm}}

\item{x_vec}{optional, the discretized evidence space}

\item{t_vec}{optional, the discretized time space}

\item{nx, nt, dx, dt}{optional, the steps and step sizes of each space}

\item{prms_solve}{optional, vector of solver settings}

\item{solver}{optional, string controlling which component values are
evaluated}

\item{prms_matrix}{optional, matrix of parameters}
}
\value{
If solver "kfe", a named list with entries "mu_vals", "x_vals", "b_vals",
"dt_b_vals", "nt_vals".

If solver "im_zero", the returned list will also contain "mu_int_vals".
}
\description{
Gets/calculates all values provided by the component functions of a
\link{drift_dm} object
}
\details{
arguments are optional, because they can be extracted from the model.
However, supplying these are faster than creating them.
}
\keyword{internal}
