% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/reg_rf.R
\name{reg_rf}
\alias{reg_rf}
\title{Random Forest for regression}
\usage{
reg_rf(attribute, nodesize = 1, ntree = 10, mtry = NULL)
}
\arguments{
\item{attribute}{attribute target to model building}

\item{nodesize}{node size}

\item{ntree}{number of trees}

\item{mtry}{number of attributes to build tree}
}
\value{
returns an object of class \code{reg_rf}obj
}
\description{
Regression via Random Forests, an ensemble of decision trees trained
on bootstrap samples with random feature subsetting at each split. This wrapper
uses the \code{randomForest} package API.
}
\details{
Random Forests reduce variance and are robust to overfitting on tabular data.
Key hyperparameters are the number of trees (\code{ntree}), the number of variables tried at
each split (\code{mtry}), and the minimum node size (\code{nodesize}).
}
\examples{
data(Boston)
model <- reg_rf("medv", ntree=10)

# preparing dataset for random sampling
sr <- sample_random()
sr <- train_test(sr, Boston)
train <- sr$train
test <- sr$test

model <- fit(model, train)

test_prediction <- predict(model, test)
test_predictand <- test[,"medv"]
test_eval <- evaluate(model, test_predictand, test_prediction)
test_eval$metrics
}
\references{
Breiman, L. (2001). Random Forests. Machine Learning 45(1):5–32.
Liaw, A. and Wiener, M. (2002). Classification and Regression by randomForest. R News.
}
