% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/getriverpoints.R
\name{getriverpoints}
\alias{getriverpoints}
\title{Calculation of river points}
\usage{
getriverpoints(
  reservoir,
  pourpoints,
  ppid,
  river_distance,
  ac_tolerance,
  e_tolerance,
  nn,
  fac = fac,
  dem = dem
)
}
\arguments{
\item{reservoir}{An sf polygon, with an unstandardised raw reservoir}

\item{pourpoints}{An sf multipoint, showing the points where rivers flow in and out of reservoirs}

\item{ppid}{An integer to index through the pourpoints dataframe}

\item{river_distance}{A number, indicating the number of meters downstream and upstream for the area of interest. Defaults to 100000 (100km)}

\item{ac_tolerance}{A number, indicating the tolerance to changes in flow accumulation. Default 2, which means that if accumulated flow changes by a factor of 2 (halved or doubled) the area of interest should not include any further downstream or upstream. This is to account for confluences.}

\item{e_tolerance}{A number indicating the tolerance to changes in elevation. Rivers flow downstream. But DEMs can show downstream areas of the river as higher, due to averaging nearby pixels. This is particularly true when rivers run through gorges. If there is no downstream lower river poitn nearby, the elevation tolerance allows the algorithm to select a point at a higher elevation, up to the threshold defined here.}

\item{nn}{A number, indicating the number of nearest neighbours to consider in the algorithm to determine river course. Higher can be more accurate but is slower. Default 100.}

\item{fac}{A rast, showing accumulated water flow along river}

\item{dem}{A rast, showing elevation}
}
\value{
A three-element list, where the first element contains the data produced by the algorithm for all points along the river, and the second element is the sf LINESTRING object for the river, and the third denotes whether the river goes upstream (0) or downstream (1)
}
\description{
Calculation of river points
}
