% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/makesystem.R
\name{makesystem}
\alias{makesystem}
\title{makesystem}
\usage{
makesystem(
  names,
  aois,
  dem = NULL,
  betweenthreshold = 1,
  bwru = TRUE,
  uprivers = NULL,
  downrivers = NULL,
  systemname = NULL
)
}
\arguments{
\item{names}{The names of dams within the same system}

\item{aois}{An sf polygon, containing all AOI areas for all dams which are part of the system}

\item{dem}{An elevation raster covering the extent of the system. This is used to determine the uppermost and lowest dams in the system.}

\item{betweenthreshold}{The minimum area in km2 considered significant for between areas (to avoid small adjoining polygons already mostly contained in other AOI polygons)}

\item{bwru}{Whether the areas between a dam system (i.e. connecting rivers) are within the bounding box of the reservoirs in that system. They will mostly be, though for some dam systems rivers can travel, for example, far to the east then back again to the west to rejoin another dam in the same system.}

\item{uprivers}{An optional parameter whether to specify the upriver dams rather than determine it based on elevation (i.e. for a 2 reservoirs meet one reservoir at a confluence).}

\item{downrivers}{An optional parameter whether to specify the downriver dams rather than determine it based on elevation (i.e. for a 2 reservoirs meet one reservoir at a confluence).}

\item{systemname}{An optional parameter to name the system, for example if the largest reservoir is not at the top of the system}
}
\value{
A set of AOI polygons for the entire system, when dams are part of a system of dams.
}
\description{
makesystem
}
