% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/evpi.R
\name{calc_evpi}
\alias{calc_evpi}
\title{Expected Value of Perfect Information (EVPI)}
\usage{
calc_evpi(psa, wtp, pop = 1)
}
\arguments{
\item{psa}{psa object from \code{\link{make_psa_obj}}}

\item{wtp}{numeric vector with willingness-to-pay (WTP) thresholds}

\item{pop}{scalar that corresponds to the total population}
}
\value{
A data frame and \code{evpi} object with the EVPI at each WTP threshold.
}
\description{
\code{calc_evpi} is used to compute the expected value of perfect information
(EVPI) from a probabilistic sensitivity analysis (PSA) dataset.
}
\section{Details}{

\code{evpi} calculates the value of eliminating all the uncertainty of a
cost-effectiveness analysis at each WTP threshold.
}

\examples{
# load psa object provided with package
data("example_psa_obj")

# define wtp threshold vector (can also use a single wtp)
wtp <- seq(1e4, 1e5, by = 1e4)
evpi <- calc_evpi(example_psa_obj, wtp)
plot(evpi) # see ?plot.evpi for options

# can use plot options (# see ?plot.evpi for details)
plot(evpi, effect_units = "QALE")

# or can use ggplot layers
plot(evpi) + ggtitle("Expected Value of Perfect Information")
}
\seealso{
\code{\link{plot.evpi}}, \code{\link{make_psa_obj}}
}
\keyword{benefit}
\keyword{expected}
\keyword{information;}
\keyword{monetary}
\keyword{net}
\keyword{of}
\keyword{perfect}
\keyword{value}
