% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/gl.rename.pop.r
\name{gl.rename.pop}
\alias{gl.rename.pop}
\title{Renames a population in a genlight object}
\usage{
gl.rename.pop(x, old = NULL, new = NULL, verbose = NULL)
}
\arguments{
\item{x}{Name of the genlight object containing SNP genotypes [required].}

\item{old}{Name of population to be changed [required].}

\item{new}{New name for the population [required].}

\item{verbose}{Verbosity: 0, silent or fatal errors; 1, begin and end; 2,
progress log; 3, progress and results summary; 5, full report
 [default 2 or as specified using gl.set.verbosity].}
}
\value{
A genlight object with the new population name.
}
\description{
Individuals are assigned to populations based on the specimen metadata data
file (csv) used with gl.read.dart().
This script renames a nominated population.
The script returns a genlight object with the new population name.
}
\examples{
   gl <- gl.rename.pop(testset.gl, old='EmsubRopeMata', new='Outgroup')
   
}
\seealso{
Other data manipulation: 
\code{\link{gl.define.pop}()},
\code{\link{gl.drop.ind}()},
\code{\link{gl.drop.loc}()},
\code{\link{gl.drop.pop}()},
\code{\link{gl.edit.recode.pop}()},
\code{\link{gl.impute}()},
\code{\link{gl.join}()},
\code{\link{gl.keep.ind}()},
\code{\link{gl.keep.loc}()},
\code{\link{gl.keep.pop}()},
\code{\link{gl.make.recode.ind}()},
\code{\link{gl.merge.pop}()},
\code{\link{gl.reassign.pop}()},
\code{\link{gl.recode.ind}()},
\code{\link{gl.recode.pop}()},
\code{\link{gl.sample}()},
\code{\link{gl.sim.genotypes}()},
\code{\link{gl.sort}()},
\code{\link{gl.subsample.ind}()},
\code{\link{gl.subsample.loc}()}
}
\author{
Custodian: Arthur Georges -- Post to
\url{https://groups.google.com/d/forum/dartr}
}
\concept{data manipulation}
