% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/gl.report.taglength.r
\name{gl.report.taglength}
\alias{gl.report.taglength}
\title{Reports summary of sequence tag length across loci}
\usage{
gl.report.taglength(
  x,
  plot.out = TRUE,
  plot_theme = theme_dartR(),
  plot_colors = two_colors,
  save2tmp = FALSE,
  verbose = NULL
)
}
\arguments{
\item{x}{Name of the genlight object containing the SNP [required].}

\item{plot.out}{If TRUE, displays a plot to guide the decision on a filter
threshold [default TRUE].}

\item{plot_theme}{Theme for the plot. See Details for options
[default theme_dartR()].}

\item{plot_colors}{List of two color names for the borders and fill of the
plots [default two_colors].}

\item{save2tmp}{If TRUE, saves any ggplots and listings to the session
temporary directory (tempdir) [default FALSE].}

\item{verbose}{Verbosity: 0, silent or fatal errors; 1, begin and end; 2,
progress log; 3, progress and results summary; 5, full report
[default 2, unless specified using gl.set.verbosity]}
}
\value{
Returns unaltered genlight object
}
\description{
SNP datasets generated by DArT typically have sequence tag lengths ranging
from 20 to 69 base pairs. This function reports summary statistics of the tag
 lengths.
}
\details{
The function \code{\link{gl.filter.taglength}} will filter out the
 loci with a tag length below a specified threshold.

Quantiles are partitions of a finite set of values into q subsets of (nearly)
equal sizes. In this function q = 20. Quantiles are useful measures because
they are less susceptible to long-tailed distributions and outliers.

\strong{ Function's output }

 The minimum, maximum, mean and a tabulation of tag length quantiles against
 thresholds are provided. Output also includes a boxplot and a
 histogram to guide in the selection of a threshold for filtering on tag
 length.

 Plots and table are saved to the temporal directory (tempdir) and can be
 accessed with the function \code{\link{gl.print.reports}} and listed with
 the function \code{\link{gl.list.reports}}. Note that they can be accessed
 only in the current R session because tempdir is cleared each time that the
 R session is closed.

 Examples of other themes that can be used can be consulted in \itemize{
 \item \url{https://ggplot2.tidyverse.org/reference/ggtheme.html} and \item
 \url{https://yutannihilation.github.io/allYourFigureAreBelongToUs/ggthemes/}
 }
}
\examples{
out <- gl.report.taglength(testset.gl)
}
\seealso{
\code{\link{gl.filter.taglength}}, \code{\link{gl.list.reports}},
 \code{\link{gl.print.reports}}

Other report functions: 
\code{\link{gl.report.bases}()},
\code{\link{gl.report.callrate}()},
\code{\link{gl.report.diversity}()},
\code{\link{gl.report.hamming}()},
\code{\link{gl.report.hwe}()},
\code{\link{gl.report.ld.map}()},
\code{\link{gl.report.locmetric}()},
\code{\link{gl.report.maf}()},
\code{\link{gl.report.monomorphs}()},
\code{\link{gl.report.overshoot}()},
\code{\link{gl.report.pa}()},
\code{\link{gl.report.parent.offspring}()},
\code{\link{gl.report.rdepth}()},
\code{\link{gl.report.replicates}()},
\code{\link{gl.report.reproducibility}()},
\code{\link{gl.report.secondaries}()},
\code{\link{gl.report.sexlinked}()}
}
\author{
Custodian: Arthur Georges -- Post to
\url{https://groups.google.com/d/forum/dartr}
}
\concept{report functions}
