% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/charts.R
\name{bar_chart}
\alias{bar_chart}
\title{Bar chart with horizontal bar and data label.}
\usage{
bar_chart(
  data,
  variable,
  axis_title = "",
  fill = "blue",
  axis_title_axis_size = 22,
  axis_text_axis_size = 22,
  data_label_size = 15,
  sort = TRUE
)
}
\arguments{
\item{data}{a dataframe object}

\item{variable}{variable name}

\item{axis_title}{axis y label. Defaults to "".}

\item{fill}{bar color. Character scale with hexidecimal color ou named color. Defaults to "blue".}

\item{axis_title_axis_size}{integer scalar. Size of axis labels. Defaults to 22.}

\item{axis_text_axis_size}{integer scalar. Size of values annotated in axis. Defaults to 22.}

\item{data_label_size}{integer scalar. Size of data labels. Defaults to 15}

\item{sort}{logical scalar. If TRUE, the are ordered using frequency. Defaults to TRUE.}
}
\value{
a ggplot2 object
}
\description{
Axis-x has the frequency and data label has the percent value.
}
\examples{
df <- data.frame(var = sample(c("A", "B"),
 size = 100, replace = TRUE))
bar_chart(df, var)
}
