% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/detect_const_cols.R
\name{detect_const_cols}
\alias{detect_const_cols}
\title{Detect if any column of a data.frame has constant values.}
\usage{
detect_const_cols(dataset, return_type = "col_names", ignore_na = F)
}
\arguments{
\item{dataset}{A data.frame}

\item{return_type}{How to return detected constant columns
Use "col_names", "col_positions" or "dataset" to return dataset with deleted constant columns}

\item{ignore_na}{Whether NA should be ignored while checking if a column has just 1 unique value}
}
\value{
. A vector of constant column-names or column positions or dataset with deleted constant columns. Use return_type parameter to specify.
}
\description{
It occasionally happens that a column in dataframe contains a single value throughout.
This could lead to redundant computational cost and unexpected behavior in Machine Learning methods.
This function scans though all columns of dataframe to examine if any column has no variation.
}
\examples{
\dontrun{
detect_const_cols(dataset = head(mutate(mtcars, mpg_2 =  999)))
}
}
