% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/dbmc.R
\name{dbmc}
\alias{dbmc}
\title{de-biased estimator}
\usage{
dbmc(x, ximp, entries_miss, est_rank)
}
\arguments{
\item{x}{the initial matrix with missing entries}

\item{ximp}{an imputed matrix, output from the package "softImpute".}

\item{entries_miss}{the missing indices}

\item{est_rank}{the rank of the matrix x, or the estimated rank from the package "softImpute".}
}
\value{
x.db the de-baised estimation matrix.
}
\description{
de-biased low-rank matrix completion estimator

This function compute a de-biased estimator from a rank-r matrix completion using
the algorithms from the package "softImpute".
}
\examples{

# simulated data
require(softImpute)
n = 100
p = 100
J = 2  # the true low-rank 
np = n*p
sig2 = 1
missfrac = 0.5
# xtrue is the underlying matrix that we do not know and want to recover it
xtrue = matrix(rnorm(n*J),n,J)\%*\%matrix(rnorm(J*p),J,p) 
# generating missing entries locations
imiss = sample(np,np*missfrac,replace=FALSE)
# xna is the observed matrix with missing entries
xna = xtrue + matrix(rnorm(np, sd = sig2),nr = n,nc = p)
xna[imiss] = NA
lamda = 2.5*sig2*sqrt(n*p)

# note that we only have xna as our initial data
# first, fit a softImpute method
fit1 = softImpute(xna, type = 'als')
# complete the matrix by a softImpute method
ximp = complete(xna,fit1)
mean((ximp - xtrue)^2);rankMatrix(ximp,.1)[1]
# now, de-biased the softImpute method
x.db = dbmc(x = xna,
            ximp = ximp,
            entries_miss = imiss,
            est_rank = 2)
mean((x.db - xtrue)^2);rankMatrix(x.db,.1)[1]





}
\references{
Chen et al (2019). Inference and uncertainty quantification for noisy matrix completion. PNAS, 116(46), 22931-22937.
}
