% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/zzz-methods-stan-code.R
\name{stan_code}
\alias{stan_code}
\title{Generate 'Stan' code for a diagnostic classification models}
\usage{
stan_code(x, ...)
}
\arguments{
\item{x}{A \link[=dcm_specify]{model specification} or
\link[=generated_quantities]{generated quantities} object.}

\item{...}{Additional arguments passed to methods.}
}
\value{
A \link[glue:as_glue]{glue} object containing the 'Stan' code for the
specified model.
}
\description{
Given a specification for a diagnostic classification model or a generated
quantities definition, automatically generate the 'Stan' code necessary to
estimate the model. For details on how the code blocks relate to diagnostic
models, see da Silva et al. (2017), Jiang and Carter (2019),
and Thompson (2019).
}
\examples{
qmatrix <- data.frame(
  att1 = sample(0:1, size = 5, replace = TRUE),
  att2 = sample(0:1, size = 5, replace = TRUE)
)

model_spec <- dcm_specify(qmatrix = qmatrix,
                          measurement_model = lcdm(),
                          structural_model = unconstrained())

stan_code(model_spec)
}
\references{
da Silva, M. A., de Oliveira, E. S. B., von Davier, A. A., and
Bazán, J. L. (2017). Estimating the DINA model parameters using the
No-U-Turn sampler. \emph{Biometrical Journal, 60}(2), 352-368.
\doi{10.1002/bimj.201600225}

Jiang, Z., & Carter, R. (2019). Using Hamiltonian Monte Carlo to
estimate the log-linear cognitive diagnosis model via Stan. \emph{Behavior
Research Methods, 51}, 651-662. \doi{10.3758/s13428-018-1069-9}

Thompson, W. J. (2019). \emph{Bayesian psychometrics for diagnostic
assessments: A proof of concept} (Research Report No. 19-01). University of
Kansas; Accessible Teaching, Learning, and Assessment Systems.
\doi{10.35542/osf.io/jzqs8}
}
