% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/ddc.R
\name{ddc}
\alias{ddc}
\title{Execute DDC to cluster the dataset}
\usage{
ddc(dist_matrix, standard_matrix, label_matrix, end_cluster_num = NULL, ...)
}
\arguments{
\item{dist_matrix}{the created dist matrix}

\item{standard_matrix}{the original data matrix}

\item{label_matrix}{the matrix including events  and labels}

\item{end_cluster_num}{the max number of cluster when the procedue ends}

\item{...}{including: mc.cores(cores used in parallel), the dtw parameters like step.pattern, keep, mc.cores}
}
\value{
the cluster array as a result, including 'Centroid', 'Elements' and 'DBAValue' for each cluster
}
\description{
Execute DDC to cluster the dataset
}
\examples{
\donttest{
original_data <- data.frame("1"=c(1, 2, 1), "2"=c(5,6,7), 
   "3"=c(4, 5, 8), "4"=c(3, 1, 9))
standard_matrix <- createStandardMatrix(data = original_data)
label_matrix <- createLabelMatrix(data = original_data)
dist_matrix <- createDistMatrix(standard_matrix = standard_matrix)
result <- ddc(dist_matrix=dist_matrix, standard_matrix=standard_matrix,
   label_matrix=label_matrix, end_cluster_num=2)
}
}
