#' @importFrom Rlibeemd emd_num_imfs ceemdan
#' @importFrom forecast nnetar forecast
#' @importFrom utils head tail
#' @importFrom graphics plot
#' @importFrom stats as.ts ts
#' @export
#'

ceemdanTDNN <- function(data, stepahead=10, num.IMFs=emd_num_imfs(length(data)),
                        s.num=4L, num.sift=50L, ensem.size=250L, noise.st=0.2){
  n.IMF <- num.IMFs
  AllIMF <- ceemdan(ts(data), num_imfs = n.IMF, ensemble_size = ensem.size, noise_strength = noise.st,
                    S_number = s.num, num_siftings = num.sift, rng_seed = 0L, threads = 0L)
  data_trn <- ts(head(data, round(length(data) - stepahead)))
  data_test <- ts(tail(data, stepahead))
  IMF_trn <- AllIMF[-c(((length(data)-stepahead)+1):length(data)),]
  Fcast_AllIMF <- NULL
  for (IMF in 1:ncol(IMF_trn)) {
    IndIMF <- NULL
    IndIMF <- IMF_trn[ ,IMF]
    ceemdanTDNNFit <- forecast::nnetar(as.ts(IndIMF))
    ceemdanTDNN_fcast=forecast::forecast(ceemdanTDNNFit, h=stepahead)
    ceemdanTDNN_fcast_Mean=ceemdanTDNN_fcast$mean
    Fcast_AllIMF <- cbind(Fcast_AllIMF, as.matrix(ceemdanTDNN_fcast_Mean))
  }
  FinalceemdanTDNN_fcast <- ts(rowSums(Fcast_AllIMF, na.rm = T))
  MAE_ceemdanTDNN=mean(abs(data_test - FinalceemdanTDNN_fcast))
  MAPE_ceemdanTDNN=mean(abs(data_test - FinalceemdanTDNN_fcast)/data_test)
  rmse_ceemdanTDNN=sqrt(mean((data_test - FinalceemdanTDNN_fcast)^2))
  Plot_IMFs <- AllIMF
  AllIMF_plots <- plot(Plot_IMFs)
  return(list(TotalIMF = n.IMF, data_test=data_test, AllIMF_forecast=Fcast_AllIMF,
              FinalceemdanTDNN_forecast=FinalceemdanTDNN_fcast, MAE_ceemdanTDNN=MAE_ceemdanTDNN,
              MAPE_ceemdanTDNN=MAPE_ceemdanTDNN, rmse_ceemdanTDNN=rmse_ceemdanTDNN,
              AllIMF_plots=AllIMF_plots))
}
