#' @importFrom Rlibeemd emd_num_imfs eemd
#' @importFrom forecast nnetar forecast
#' @importFrom utils head tail
#' @importFrom graphics plot
#' @importFrom stats as.ts ts
#' @export
#'

eemdTDNN <- function(data, stepahead=10, num.IMFs=emd_num_imfs(length(data)),
                     s.num=4L, num.sift=50L, ensem.size=250L, noise.st=0.2){
  n.IMF <- num.IMFs
  AllIMF <- eemd(ts(data), num_imfs = n.IMF, ensemble_size = ensem.size, noise_strength = noise.st,
                 S_number = s.num, num_siftings = num.sift, rng_seed = 0L, threads = 0L)
  data_trn <- ts(head(data, round(length(data) - stepahead)))
  data_test <- ts(tail(data, stepahead))
  IMF_trn <- AllIMF[-c(((length(data)-stepahead)+1):length(data)),]
  Fcast_AllIMF <- NULL
  for (IMF in 1:ncol(IMF_trn)) {
    IndIMF <- NULL
    IndIMF <- IMF_trn[ ,IMF]
    eemdTDNNFit <- forecast::nnetar(as.ts(IndIMF))
    eemdTDNN_fcast=forecast::forecast(eemdTDNNFit, h=stepahead)
    eemdTDNN_fcast_Mean=eemdTDNN_fcast$mean
    Fcast_AllIMF <- cbind(Fcast_AllIMF, as.matrix(eemdTDNN_fcast_Mean))
  }
  FinaleemdTDNN_fcast <- ts(rowSums(Fcast_AllIMF, na.rm = T))
  MAE_eemdTDNN=mean(abs(data_test - FinaleemdTDNN_fcast))
  MAPE_eemdTDNN=mean(abs(data_test - FinaleemdTDNN_fcast)/data_test)
  rmse_eemdTDNN=sqrt(mean((data_test - FinaleemdTDNN_fcast)^2))
  Plot_IMFs <- AllIMF
  AllIMF_plots <- plot(Plot_IMFs)
  return(list(TotalIMF = n.IMF, data_test=data_test, AllIMF_forecast=Fcast_AllIMF,
              FinaleemdTDNN_forecast=FinaleemdTDNN_fcast, MAE_eemdTDNN=MAE_eemdTDNN,
              MAPE_eemdTDNN=MAPE_eemdTDNN, rmse_eemdTDNN=rmse_eemdTDNN,
              AllIMF_plots=AllIMF_plots))
}
