% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/deepspat_main_bivar_GP.R
\name{deepspat_bivar_GP}
\alias{deepspat_bivar_GP}
\title{Deep bivariate compositional spatial model for Gaussian processes}
\usage{
deepspat_bivar_GP(
  f,
  data,
  g = ~1,
  layers_asym = NULL,
  layers = NULL,
  method = "REML",
  family = c("exp_stat_symm", "exp_stat_asymm", "exp_nonstat_symm", "exp_nonstat_asymm",
    "matern_stat_symm", "matern_stat_asymm", "matern_nonstat_symm",
    "matern_nonstat_asymm"),
  par_init = initvars(),
  learn_rates = init_learn_rates(),
  nsteps = 150L
)
}
\arguments{
\item{f}{formula identifying the dependent variables and the spatial inputs in the covariance}

\item{data}{data frame containing the required data}

\item{g}{formula identifying the independent variables in the linear trend}

\item{layers_asym}{list containing the aligning function layers}

\item{layers}{list containing the nonstationary warping layers}

\item{method}{identifying the method for finding the estimates}

\item{family}{identifying the family of the model constructed}

\item{par_init}{list of initial parameter values. Call the function \code{initvars()} to see the structure of the list}

\item{learn_rates}{learning rates for the various quantities in the model. Call the function \code{init_learn_rates()} to see the structure of the list}

\item{nsteps}{number of steps when doing gradient descent times two, three or five (depending on the family of model)}
}
\value{
\code{deepspat_bivar_GP} returns an object of class \code{deepspat_bivar_GP} with the following items
\describe{
 \item{"f"}{The formula used to construct the covariance model}
 \item{"g"}{The formula used to construct the linear trend model}
 \item{"data"}{The data used to construct the deepspat model}
 \item{"X"}{The model matrix of the linear trend}
 \item{"layers"}{The warping function layers in the model}
 \item{"layers_asym"}{The aligning function layers in the model}
 \item{"Cost"}{The final value of the cost}
 \item{"eta_tf"}{Estimated weights in the warping layers as a list of \code{TensorFlow} objects}
 \item{"eta_tf_asym"}{Estimated weights in the aligning layers as a list of \code{TensorFlow} objects}
 \item{"a_tf"}{Estimated parameters in the LFT layers}
 \item{"a_tf_asym"}{Estimated parameters in the AFF layers of the aligning function}
 \item{"beta"}{Estimated coefficients of the linear trend}
 \item{"precy_tf1"}{Precision of measurement error of the first process, as a \code{TensorFlow} object}
 \item{"precy_tf2"}{Precision of measurement error of the second process, as a \code{TensorFlow} object}
 \item{"sigma2_tf_1"}{Variance parameter (first process) in the covariance matrix, as a \code{TensorFlow} object}
 \item{"sigma2_tf_2"}{Variance parameter (second process) in the covariance matrix, as a \code{TensorFlow} object}
 \item{"sigma2_tf_12"}{Covariance parameter in the covariance matrix, as a \code{TensorFlow} object}
 \item{"l_tf1"}{Length scale parameter (first process) in the covariance matrix, as a \code{TensorFlow} object}
 \item{"l_tf2"}{Length scale parameter (second process) in the covariance matrix, as a \code{TensorFlow} object}
 \item{"l_tf12"}{Length scale parameter (cross-covariance) in the covariance matrix, as a \code{TensorFlow} object}
 \item{"nu_tf1"}{Smoothness parameter (first process) in the covariance matrix, as a \code{TensorFlow} object}
 \item{"nu_tf2"}{Smoothness parameter (second process) in the covariance matrix, as a \code{TensorFlow} object}
 \item{"nu_tf12"}{Smoothness parameter (cross-covariance) in the covariance matrix, as a \code{TensorFlow} object}
 \item{"scalings"}{Minima and maxima used to scale the unscaled unit outputs for each warping layer, as a list of \code{TensorFlow} objects}
 \item{"scalings_asym"}{Minima and maxima used to scale the unscaled unit outputs for each aligning layer, as a list of \code{TensorFlow} objects}
 \item{"method"}{Method used for inference}
 \item{"nlayers"}{Number of warping layers in the model}
 \item{"nlayers_asym"}{Number of aligning layers in the model}
 \item{"swarped_tf1"}{Spatial locations of the first process on the warped domain}
 \item{"swarped_tf2"}{Spatial locations of the second process on the warped domain}
 \item{"negcost"}{Vector of costs after each gradient-descent evaluation}
 \item{"z_tf_1"}{Data of the first process}
 \item{"z_tf_2"}{Data of the second process}
 \item{"family"}{Family of the model}
 }
}
\description{
Constructs a deep bivariate compositional spatial model
}
\examples{
\donttest{
if (reticulate::py_module_available("tensorflow")) {
df <- data.frame(s1 = rnorm(100), s2 = rnorm(100), z1 = rnorm(100), z2 = rnorm(100))
layers <- c(AWU(r = 50L, dim = 1L, grad = 200, lims = c(-0.5, 0.5)),
            AWU(r = 50L, dim = 2L, grad = 200, lims = c(-0.5, 0.5)))
d <- deepspat_bivar_GP(f = z1 + z2 ~ s1 + s2 - 1,
                       data = df, g = ~ 1,
                       layers = layers, method = "REML",
                       family = "matern_nonstat_symm",
                       nsteps = 10L)
 }
}
}
