% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/data.R
\docType{data}
\name{ShiftsWorked}
\alias{ShiftsWorked}
\title{Synthetic data set listing daily shift pattern for fictitious employees}
\format{
A data frame with 3,100 rows and 6 columns:
\describe{
\item{Record ID}{Table primary key (integer)}
\item{Employee}{Name of listed employee}
\item{Date}{The date being considered}
\item{Shift}{The shift-type done by \code{employee} on \code{date}.  One of 'Day', 'Night' or 'Rest'.}
\item{Shift Start}{Shift start time (missing if on 'Rest' shift)}
\item{Shift End}{Shift end time (missing if on 'Rest' shift)}
\item{Daily Pay}{Shift end time (missing if on 'Rest' shift)}
}
}
\usage{
ShiftsWorked
}
\description{
A synthetic data set intended to demonstrate the design and application of a
deidentification pipeline.  Employee names are entirely fictitious and constructed
from the
\href{https://www.kaggle.com/datasets/fivethirtyeight/fivethirtyeight-most-common-name-dataset?resource=download&select=new-top-surnames.csv}{\verb{FiveThirtyEight Most Common Name Dataset}}.
}
\keyword{datasets}
