% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/api.R
\name{add_numeric_blur}
\alias{add_numeric_blur}
\title{De-identification via numeric aggregation}
\usage{
add_numeric_blur(object, ..., cuts = 0)
}
\arguments{
\item{object}{Either a \code{data.frame}, \code{tibble}, or existing \code{DeidentList} pipeline.}

\item{...}{variables to be transformed.}

\item{cuts}{The position in which data is to be divided.}
}
\value{
A 'DeidentList' representing the untrained transformation pipeline.
The object contains fields:
\itemize{
\item \code{deident_methods} a list of each step in the pipeline (consisting of \code{variables} and \code{method})
}

and methods:
\itemize{
\item \code{mutate} apply the pipeline to a new data set
\item \code{to_yaml} serialize the pipeline to a '.yml' file
}
}
\description{
\code{add_numeric_blur()} adds an bluring step to a transformation pipeline
(NB: intended for numeric data).  When ran as a transformation, the data is
split into intervals depending on the \code{cuts} supplied of the series
[-Inf, cut.1), [cut.1, cut.2), ..., [cut.n, Inf] where
\code{cuts} = c(cut.1, cut.2, ..., cut.n).
}
\keyword{API}
