% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/make_asv_abund_matrix.R
\name{make_asv_abund_matrix}
\alias{make_asv_abund_matrix}
\title{Make an amplified sequence variant (ASV) abundance matrix for each of the input barcodes}
\usage{
make_asv_abund_matrix(analysis_setup, overwrite_existing = FALSE)
}
\arguments{
\item{analysis_setup}{An object containing directory paths and
data tables, produced by the \code{prepare_reads} function}

\item{overwrite_existing}{Logical, indicating whether to overwrite existing
results. Default is FALSE.}
}
\value{
The ASV abundance matrix (\code{asv_abund_matrix})
}
\description{
Make an amplified sequence variant (ASV) abundance matrix for each of the input barcodes
}
\details{
The function processes data for each unique barcode separately,
inferring ASVs, merging reads, and creating an ASV abundance matrix.
To do this, the 'DADA2' core denoising alogrithm is used to infer ASVs.
}
\examples{
\donttest{
# The primary wrapper function for 'DADA2' ASV inference steps
analysis_setup <- prepare_reads(
  data_directory = system.file("extdata", package = "demulticoder"),
  output_directory = tempdir(),
  overwrite_existing = TRUE
)
cut_trim(
analysis_setup,
cutadapt_path="/usr/bin/cutadapt",
overwrite_existing = TRUE
)
make_asv_abund_matrix(
analysis_setup,
overwrite_existing = TRUE
)
}
}
