% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/prepare_reads_count_primers.R
\name{setup_directories}
\alias{setup_directories}
\title{Set up directory paths for subsequent analyses}
\usage{
setup_directories(
  data_directory = "data",
  output_directory = tempdir(),
  tempdir_path = NULL,
  tempdir_id = "demulticoder_run"
)
}
\arguments{
\item{data_directory}{Directory path where the user has placed
raw FASTQ (forward and reverse reads), metadata.csv, and
primerinfo_params.csv files. Default is "data".}

\item{output_directory}{User-specified directory path for outputs. Default is
tempdir().}

\item{tempdir_path}{Path to a temporary directory. If \code{NULL}, a temporary
directory path will be identified using the \code{tempdir()} command.}

\item{tempdir_id}{ID for temporary directories. The user can provide any helpful ID, whether it be a date or specific name for the run. Default is "demulticoder_run".}
}
\value{
A list with paths for data, output, temporary directories, primer,
and metadata files.
}
\description{
This function sets up the directory paths for subsequent analyses. It checks
whether the specified output directories exist or creates them if they don't.
The function also provides paths to primer and metadata files within the data
directory.
}
\keyword{internal}
