% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/mean.detrended.dm.R
\name{mean_detrended.dm}
\alias{mean_detrended.dm}
\title{Calculate mean of detrended dendrometer data.}
\usage{
mean_detrended.dm(detrended.dm, ac1.remove = T, robust.mean = T)
}
\arguments{
\item{detrended.dm}{dataframe output data frame of \code{dm.detrend} function.}

\item{ac1.remove}{logical if TRUE removes first order autocorrelation.}

\item{robust.mean}{logical if TRUE calculates robust mean.}
}
\value{
A data frame with the mean of detrended dendrometer series.
}
\description{
This function calculate the mean detrended series of dendrometer data. It is usefull to make a single averaged detrended dendrometer series of a species in a site. Further, it provides option for removing first order autocorrelation from dendrometer series using \code{auto.arima} function of "forecast" package.
}
\examples{
\donttest{library(dendRoAnalyst)
data(gf_nepa17)
detrended<-dm.detrend(df=nepa17, method='f_diff', CalYear=2017)
m_detre <- mean_detrended.dm(detrended)
head(m_detre,10)}

}
