% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/fit_distributions.R
\name{create_objective}
\alias{create_objective}
\title{Create Objective Function for MPS or MLE}
\usage{
create_objective(method, x, dist, tol_spacing, ties_method, custom_functions)
}
\arguments{
\item{method}{character string: "mle" or "mps".}

\item{x}{numeric vector of sorted data.}

\item{dist}{character string specifying the distribution.}

\item{tol_spacing}{numeric tolerance for spacings/densities.}

\item{ties_method}{character string for ties correction.}

\item{custom_functions}{list of custom distribution functions.}
}
\value{
A function that computes the objective value given parameters.
}
\description{
Creates the objective function for optimization-based estimation methods.
For MLE, returns negative log-likelihood. For MPS, returns negative log-product-spacing
with optional ties correction.
}
\keyword{internal}
