% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/plot.R
\name{plot_bivariate}
\alias{plot_bivariate}
\title{Densityratio in two-dimensional plot}
\usage{
plot_bivariate(
  x,
  vars = NULL,
  samples = "both",
  grid = FALSE,
  logscale = TRUE,
  show.sample = FALSE,
  tol = 0.01,
  ...
)
}
\arguments{
\item{x}{Density ratio object created with e.g., \code{\link[=kliep]{kliep()}}, \code{\link[=ulsif]{ulsif()}},
or \code{\link[=naive]{naive()}}}

\item{vars}{Character vector of variable names for which all pairwise
bivariate plots are created}

\item{samples}{Character string indicating whether to plot the 'numerator',
'denominator', or 'both' samples. Default is 'both'.}

\item{grid}{Logical indicating whether output should be a list of individual plots ("individual"), or one facetted plot with all variables ("assembled"). Defaults to "individual".}

\item{logscale}{Logical indicating whether to plot the density ratio
estimates on a log scale. Default is \code{TRUE}.}

\item{show.sample}{Logical indicating whether to give different shapes to
observations, depending on the sample they come from (numerator or
denominator). Defaults to \code{FALSE}.}

\item{tol}{Numeric indicating the tolerance: values below this value will be set to the tolerance value, for legibility of the plots}

\item{...}{Additional arguments passed to the predict() function.}
}
\value{
Bivariate scatter plots of all combinations of variables in vars.
}
\description{
Plots a scatterplot of two variables, with densityratio mapped to the colour
scale.
}
\examples{
set.seed(123)
# Fit model
dr <- ulsif(numerator_small, denominator_small)
# Inspect model object
dr
# Obtain summary of model object
summary(dr)
# Plot model object
plot(dr)
# Plot density ratio for each variable individually
plot_univariate(dr)
# Plot density ratio for each pair of variables
plot_bivariate(dr)
# Predict density ratio and inspect first 6 predictions
head(predict(dr))
# Fit model with custom parameters
ulsif(numerator_small, denominator_small, sigma = 2, lambda = 2)
}
