% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/spatial.depth.R
\name{spatial.depth}
\alias{spatial.depth}
\title{Spatial Depth}
\usage{
spatial.depth(x, data)
}
\arguments{
\item{x}{A matrix or a data.frame of objects (numerical vector as one object) whose depth is to be found; each row consists a p-variate observation.}

\item{data}{A matrix or a data.frame of objects which acts as the data cloud. Each row consists of a p-variate observation.}
}
\value{
Numerical vector of depths, one for each row in \code{x}; or one depth value if \code{x} is numerical.
}
\description{
\code{spatial.depth} is used to find the spatial depth of one or more p-variate observation(s) in a data cloud of numerous p-variate observations.
}
\examples{
u<-matrix(rnorm(90,0,1),ncol=3)
u0<-matrix(runif(9,0,1),ncol=3)
spatial.depth(u0,u)
}
\author{
Somedip Karmakar <somedip@yahoo.co.in>

Omker Mahalanobish <omker.scorpio@gmail.com>
}

