% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/cont_table.R
\name{cont_table}
\alias{cont_table}
\alias{joint}
\alias{conditional}
\alias{marginal}
\title{Contingency table}
\usage{
cont_table(
  data,
  x1,
  x2,
  weights = NULL,
  freq = NULL,
  total = FALSE,
  xfirst1 = NULL,
  xlast1 = NULL,
  wlast1 = NULL,
  xfirst2 = NULL,
  xlast2 = NULL,
  wlast2 = NULL
)

joint(data)

conditional(data, x = NULL)

marginal(data, x = NULL, f = "f", vals = NULL)
}
\arguments{
\item{data}{a tibble,}

\item{x1, x2}{the two series used the construct the contingency
table, the distinct values of the first and the second will
respectively be the rows and the columns of the contingency
table,}

\item{weights}{a series containing the weights that should be used
to mimic the population,}

\item{freq}{the frequencies (in the case where data is already
contingency table),}

\item{total}{if \code{TRUE}, a total is added to the table,}

\item{xfirst1, xfirst2, xlast1, xlast2, wlast1, wlast2}{see \code{\link[=as_numeric]{as_numeric()}},}

\item{x}{the series on which the operation should be computed,}

\item{f}{see \code{\link[=freq_table]{freq_table()}},}

\item{vals}{see \code{\link[=freq_table]{freq_table()}},}
}
\value{
a tibble
}
\description{
A contingency table returns the counts of all the combinations of
the modalities of two series in a table for which every modality of
the first series is a row and every modality of the second series
is a column. The \code{joint}, \code{marginal} and \code{conditional} functions
compute these three distributions from the contingency table (by
indicating one series for the last two).
}
\details{
\code{cont_table} actually returns a tibble in "long format", as the
\code{dplyr::count} table does. As the returned object is of class
\code{cont_table}, this is the \code{format} and \code{print} methods that turns
the tibble in a wide format before printing.

The \code{conditional} and \code{joint} functions return a \code{cont_table}
object, as the \code{marginal} function returns a \code{freq_table} object.
}
\examples{
library("dplyr")
# get a contingency table containing education and sex
cont_table(employment, education, sex)
# instead of counts, sum the weights
cont_table(employment, education, sex, weights = weights)
# get the joint distribution and the conditional and marginal
# distribution of sex
cont_table(employment, education, sex) \%>\% joint
cont_table(employment, education, sex) \%>\% marginal(sex)
cont_table(employment, education, sex) \%>\% conditional(sex)
}
\author{
Yves Croissant
}
\keyword{manip}
